unit FormMonitor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, ExtCtrls;

type
  TFMonitor = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    Memo: TMemo;
    SpeedButton1: TSpeedButton;
    procedure sbHideClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FMonitor: TFMonitor;

implementation
{$R *.dfm}
Uses
   DataModule;

procedure TForFMonitorHideClick(Sender: TObject);
begin
   FMonitor.Hide();
end;

procedure TFMonitor.sbHideClick(Sender: TObject);
begin
   hide();
end;

procedure TFMonitor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TFMonitor.FormDestroy(Sender: TObject);
begin
   FMonitor := NIL;
end;

procedure TFMonitor.FormCreate(Sender: TObject);
begin
   if FileExists('sql.log') then begin
      Memo.Clear();
      Memo.Lines.LoadFromFile('sql.log')
   end;
end;

procedure TFMonitor.SpeedButton1Click(Sender: TObject);
begin
   Close();
end;

end.
